/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.error;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicSmoothScrollingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5225;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector3f;

@ApiStatus.Internal
public class ErrorsEntryListWidget
extends DynamicSmoothScrollingEntryListWidget<Entry> {
    private boolean inFocus;

    public ErrorsEntryListWidget(class_310 client, int width, int height, int startY, int endY) {
        super(client, width, height, startY, endY, InternalTextures.LEGACY_DIRT);
    }

    public void _clearItems() {
        this.clearItems();
    }

    private Entry _getEntry(int index) {
        return (Entry)((Object)this.method_25396().get(index));
    }

    public void _addEntry(Entry entry) {
        this.addItem(entry);
    }

    public int getItemWidth() {
        return this.width - 80;
    }

    protected int getScrollbarPosition() {
        return this.width - 40;
    }

    @Nullable
    private static class_2583 styleAtWidth(class_5481 text, int width, class_327 font) {
        class_5225 splitter;
        class_5225 class_52252 = splitter = font.method_27527();
        Objects.requireNonNull(class_52252);
        class_5225.class_5230 sink = new class_5225.class_5230(class_52252, (float)width);
        MutableObject result = new MutableObject();
        text.accept((i, style, codepoint) -> {
            if (!sink.accept(i, style, codepoint)) {
                result.setValue((Object)style);
                return false;
            }
            return true;
        });
        return (class_2583)result.getValue();
    }

    public static abstract class Entry
    extends DynamicEntryListWidget.Entry<Entry> {
        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }

        public void method_25365(boolean bl) {
        }

        public boolean method_25370() {
            return false;
        }
    }

    public static class LinkEntry
    extends Entry {
        private class_2561 text;
        private List<class_5481> textSplit;
        private String link;
        private boolean contains;

        public LinkEntry(class_2561 text, String link, int width) {
            this.text = text;
            this.textSplit = class_310.method_1551().field_1772.method_1728((class_5348)text, width - 6);
            this.link = link;
        }

        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                graphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"Click to open link."), mouseX, mouseY);
                int yy = y;
                for (class_5481 textSp : this.textSplit) {
                    class_5481 underlined = characterVisitor -> textSp.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.method_27706(class_124.field_1073), codePoint));
                    graphics.method_35720(class_310.method_1551().field_1772, underlined, x + 5, yy, -14695425);
                    yy += 12;
                }
            } else {
                int yy = y;
                for (class_5481 textSp : this.textSplit) {
                    graphics.method_35720(class_310.method_1551().field_1772, textSp, x + 5, yy, -14695425);
                    yy += 12;
                }
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (this.contains && event.method_74245() == 0) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                try {
                    class_156.method_668().method_673(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    public static class ImageEntry
    extends Entry {
        private class_1043 texture;
        private class_2960 id;
        private int width;
        private int height;

        public ImageEntry(int width, class_1043 texture, class_2960 id) {
            this.id = id;
            this.texture = texture;
            this.width = (width - 6) / 2;
            class_1011 image = texture.method_4525();
            this.height = (int)((double)this.width * ((double)image.method_4323() / (double)image.method_4307()));
        }

        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            class_1011 image = this.texture.method_4525();
            this.width = (entryWidth - 6) / 2;
            this.height = (int)((double)this.width * ((double)image.method_4323() / (double)image.method_4307()));
            graphics.method_25294(x, y, x + this.width, y + this.height + 2, -1);
            graphics.method_25295(class_10799.field_56883, this.id, x + 1, x + this.width - 1, y + 1, y + this.height + 1, 0.0f, 0.0f, 1.0f, 0.0f, 1);
        }

        public int getItemHeight() {
            return this.height + 2;
        }
    }

    public static class HorizontalRuleEntry
    extends Entry {
        private int width;

        public HorizontalRuleEntry(int width) {
            this.width = width;
        }

        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (this.width != entryWidth) {
                this.width = entryWidth;
            }
            graphics.method_25294(x + 2, y + 2, x + this.width - 6 - 2, y + 3, -8947849);
        }

        public int getItemHeight() {
            return 5;
        }
    }

    public static class TextEntry
    extends Entry {
        private class_2561 text;
        private int width;
        private List<class_5481> textSplit;
        private int savedX;
        private int savedY;

        public TextEntry(class_2561 text, int width) {
            this.text = text;
            this.width = width - 6;
            this.textSplit = text.getString().trim().isEmpty() ? Collections.singletonList(text.method_30937()) : class_310.method_1551().field_1772.method_1728((class_5348)text, this.width);
        }

        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            class_2568 hoverEvent;
            if (this.width != entryWidth - 6) {
                this.width = entryWidth - 6;
                this.textSplit = this.text.getString().trim().isEmpty() ? Collections.singletonList(this.text.method_30937()) : class_310.method_1551().field_1772.method_1728((class_5348)this.text, this.width);
            }
            this.savedX = x;
            this.savedY = y;
            int yy = y;
            for (class_5481 textSp : this.textSplit) {
                graphics.method_35720(class_310.method_1551().field_1772, textSp, x + 5, yy, -1);
                yy += 12;
            }
            class_2583 style = this.getTextAt(mouseX, mouseY);
            class_437 screen = class_310.method_1551().field_1755;
            if (style != null && screen != null && style.method_10969() != null && (hoverEvent = style.method_10969()) instanceof class_2568.class_10613) {
                class_2561 component;
                class_2568.class_10613 class_106132 = (class_2568.class_10613)hoverEvent;
                try {
                    class_2561 class_25612;
                    component = class_25612 = class_106132.comp_3510();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                graphics.method_51447(class_310.method_1551().field_1772, class_310.method_1551().field_1772.method_1728((class_5348)component, Math.max(this.width / 2, 200)), x, y);
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            class_2583 style;
            if (event.method_74245() == 0 && (style = this.getTextAt(event.comp_4798(), event.comp_4799())) != null && style.method_10970() != null) {
                class_437.method_71999((class_2558)style.method_10970(), (class_310)class_310.method_1551(), (class_437)class_310.method_1551().field_1755);
                return true;
            }
            return super.method_25402(event, doubleClick);
        }

        @Nullable
        private class_2583 getTextAt(double x, double y) {
            int lineCount = this.textSplit.size();
            if (lineCount > 0) {
                int line;
                int textX = class_3532.method_15357((double)(x - (double)this.savedX));
                int textY = class_3532.method_15357((double)(y - (double)this.savedY));
                if (textX >= 0 && textY >= 0 && textX <= this.width && textY < 12 * lineCount + lineCount && (line = textY / 12) < this.textSplit.size()) {
                    class_5481 orderedText = this.textSplit.get(line);
                    return ErrorsEntryListWidget.styleAtWidth(orderedText, textX, class_310.method_1551().field_1772);
                }
            }
            return null;
        }
    }

    public static class ScaledEntry
    extends Entry
    implements class_4069 {
        public final Entry entry;
        public final float scale;
        public final Matrix3x2f transform;
        @Nullable
        private class_364 focused;
        private boolean isDragging;

        public ScaledEntry(Entry entry, float scale) {
            this.entry = entry;
            this.scale = scale;
            this.transform = new Matrix3x2f().scale(scale, scale);
        }

        public Entry getEntry() {
            this.entry.setParent(this.getParent());
            return this.entry;
        }

        private Vector3f transformMouse(double mouseX, double mouseY) {
            Vector3f mouse = new Vector3f((float)mouseX, (float)mouseY, 1.0f);
            this.transform.transform(mouse);
            return mouse;
        }

        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Vector3f mouse = this.transformMouse(mouseX, mouseY);
            graphics.method_51448().pushMatrix();
            graphics.method_51448().mul((Matrix3x2fc)this.transform);
            Vector3f pos = new Vector3f((float)x, (float)y, 1.0f);
            pos.mul((Matrix3x2fc)new Matrix3x2f().scale(1.0f / this.scale, 1.0f / this.scale));
            this.getEntry().render(graphics, index, Math.round(pos.y()), Math.round(pos.x()), Math.round((float)entryWidth / this.scale), Math.round((float)entryHeight / this.scale), (int)mouse.x(), (int)mouse.y(), isSelected, delta);
            graphics.method_51448().popMatrix();
        }

        public int getItemHeight() {
            return this.getEntry().getItemHeight();
        }

        @Override
        public List<? extends class_6379> narratables() {
            return this.getEntry().narratables();
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.getEntry());
        }

        public boolean method_25405(double mouseX, double mouseY) {
            Vector3f mouse = this.transformMouse(mouseX, mouseY);
            return super.method_25405((double)mouse.x(), (double)mouse.y());
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            Vector3f mouse = this.transformMouse(event.comp_4798(), event.comp_4799());
            return super.method_25402(new class_11909((double)mouse.x(), (double)mouse.y(), event.comp_4800()), doubleClick);
        }

        public boolean method_25406(class_11909 event) {
            Vector3f mouse = this.transformMouse(event.comp_4798(), event.comp_4799());
            return super.method_25406(new class_11909((double)mouse.x(), (double)mouse.y(), event.comp_4800()));
        }

        public boolean method_25403(class_11909 event, double f, double g) {
            Vector3f mouse = this.transformMouse(event.comp_4798(), event.comp_4799());
            return super.method_25403(new class_11909((double)mouse.x(), (double)mouse.y(), event.comp_4800()), f, g);
        }

        public boolean method_25401(double d, double e, double amountX, double amountY) {
            Vector3f mouse = this.transformMouse(d, e);
            return super.method_25401((double)mouse.x(), (double)mouse.y(), amountX, amountY);
        }

        public final boolean method_25397() {
            return this.isDragging;
        }

        public final void method_25398(boolean dragging) {
            this.isDragging = dragging;
        }

        @Nullable
        public class_364 method_25399() {
            return this.focused;
        }

        public void method_25395(@Nullable class_364 focused) {
            this.focused = focused;
        }
    }

    public static class IndentedEntry
    extends Entry
    implements class_4069 {
        public final Entry entry;
        public final int indent;
        @Nullable
        private class_364 focused;
        private boolean isDragging;

        public IndentedEntry(Entry entry, int indent) {
            this.entry = entry;
            this.indent = indent;
        }

        public Entry getEntry() {
            this.entry.setParent(this.getParent());
            return this.entry;
        }

        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.getEntry().render(graphics, index, y, x + this.indent, entryWidth - this.indent, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        public int getItemHeight() {
            return this.getEntry().getItemHeight();
        }

        @Override
        public List<? extends class_6379> narratables() {
            return this.getEntry().narratables();
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.getEntry());
        }

        public final boolean method_25397() {
            return this.isDragging;
        }

        public final void method_25398(boolean dragging) {
            this.isDragging = dragging;
        }

        @Nullable
        public class_364 method_25399() {
            return this.focused;
        }

        public void method_25395(@Nullable class_364 focused) {
            this.focused = focused;
        }
    }

    public static class EmptyEntry
    extends Entry {
        public final int height;

        public EmptyEntry(int height) {
            this.height = height;
        }

        public void render(class_332 graphics, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        }

        public int getItemHeight() {
            return this.height;
        }
    }
}

